* normal_plot3.sas;
options pageno=1 linesize=80;
goptions reset=all;
title "Normal probability densities";
title2 "Three sets of parameters";
data normal_plot;
	* Three sets of normal parameters here;
	mu_1 = 0; sig2_1 = 1; 
	mu_2 = 2; sig2_2 = 2; 
	mu_3 = 2; sig2_3 = 0.5;
	* Minimum and maximum values of y;
	ymin = -4;
	ymax = 6;
	* Divisions between ymin and ymax (more = smoother graph);
	ydiv = 100;
	* Calculate step length;
	ylength = (ymax-ymin)/ydiv;
	* Find y and f(y) values for the plot;
	do i=0 to ydiv;
		y = ymin + i*ylength;
		* normal probability density function;
		fy_1 = (1/sqrt(2*3.14159*sig2_1))*exp(-((y-mu_1)**2)/(2*sig2_1));
		fy_2 = (1/sqrt(2*3.14159*sig2_2))*exp(-((y-mu_2)**2)/(2*sig2_2));
		fy_3 = (1/sqrt(2*3.14159*sig2_3))*exp(-((y-mu_3)**2)/(2*sig2_3));
		* Output y and fy1, fy2, fy3 to SAS data file;
		output;
	end;
run;
* Print data;
proc print data=normal_plot;
run;
* Plot probability density function;
proc gplot data=normal_plot;
	plot fy_1*y=1 fy_2*y=2 fy_3*y=3 / vref=0 wvref=3 vaxis=axis1 haxis=axis1 overlay;
	symbol1 i=join v=none c=black width=3;
	symbol2 i=join v=none c=blue width=3;
	symbol3 i=join v=none c=red width=3;
	axis1 label=(height=2) value=(height=2) width=3 major=(width=2) minor=none;
run;
quit;
